// This JS file is designed to give you a way to have the audio
// button on the toolbar work with frameset lesson pages that have
// an audio clip in one of the child frames.
//
// To make this work you need to:
// 1. include this js file in the frameset document.
// 2. place an audio embed in one of the frame documents.
// 3. make a call to audioReference.setClipRef(), passing the reference
//    to the clip created in step 2 (this is probably best done
//    in the onLoad handler for the document which holds the
//    actual audio clip.  If this is done, then remember to
//    call parent.audioReference.setClipRef() instead of 
//    audioReference.setClipRef()).
// 
// Note: a reference to the actual clip can be obtained through a 
// call to G2_getClipRef("ClipName",documentReference), where
// "ClipName" is a string holding the name of the audio clip
// and documentReference is a reference to the document where
// the clip resides.



// AudioAdapter is an object that acts as an adapter to an
// actual AudioClip.  It has member functions that allow you
// to stop and play audio clips.  It is useful in situations
// where there is an audio clip to be played, but the location
// of the clip is not known to the caller.
//
// Although this object was originally designed to act as a 
// mechanism for allowing the toolbar's audio button to become
// enabled on frameset pages, it can also be instantiated and
// used in any situation where the actual location of an
// audio clip is not going to be known to the caller.
// 
// AudioAdapter takes an optional clipReference as a parameter.
// The AudioAdapter member functions play and stop will not
// work properly unless a valid clip Reference has been supplied.
function AudioAdapter(ref)
{
	this.stop = AudioAdapterStop;
	this.play = AudioAdapterPlay;
	this.setClipRef = AudioAdapterSetClipRef;
	this.clipRef = ref;
	
	return this;
}

// The setClipRef member function for AudioAdapter
function AudioAdapterSetClipRef(ref)
{
	if (ref != null)
	{
		this.clipRef = ref;
	}
}

// The stop member function for AudioAdapter
function AudioAdapterStop()
{
	if (this.clipRef == null)
	{
		alert("Error in call to AudioAdapter.stop():\nNo clip reference has been defined.");
		return;
	}
	else
	{
		G2_stop(this.clipRef);
	}
}

// The play member function for AudioAdapter
function AudioAdapterPlay()
{
	if (this.clipRef == null)
	{
		alert("Error in call to AudioAdapter.play():\nNo clip reference has been defined.");
		return;
	}
	else
	{
		G2_play(this.clipRef);
	}
}

// audioReference is the object that the toolbar looks for when
// deciding whether or not to enable the audio button.
var audioReference = new AudioAdapter();
